'''
Roman centurion

Imagine a cruel Roman centurion (or a very smart virus), who releases only 
one out of all prisoners alive. He does this by removing every N-th prisoner, 
until he is left with a sole survivor. 

Your task is to predict, with a given number of prisoners and value for 
`kill_every`, which prisoner will survive.

Given the number of prisoners `nb_prisoners` and the kill-every number 
`kill_every`, make a function which predicts which prisoner will survive.
For example `nb_prisoners=10`, `kill_every=3`, results in prisoner number 4 
surviving:

0 1 2 3 4 5 6 7 8 9   -> kill 2
0 1   3 4 5 6 7 8 9   -> kill 5
0 1   3 4   6 7 8 9   -> kill 8
0 1   3 4   6 7   9   -> kill 1
0     3 4   6 7   9   -> kill 6
0     3 4     7   9   -> kill 0
      3 4     7   9   -> kill 7
      3 4         9   -> kill 4
      3           9   -> kill 9
      3               -> the fourth prisoner survived (note Python counts from 0)

Exercise A: 
Predict what is the best programming approach.
Before you start programming, think about the easiest way to implement. 
Check the attached image for three representations of possible Python implementations.
'''

'''
Exercise B:
Implement your choice of centurion

If you cannot choose, you are recommended to start with the lazy centurion (who 
sits down, lets the prisoners walk and kills every N-th person).
- Note that stitching of NumPy arrays is done with `np.concatenate([a,b])`.
- Write pseudocode first.
- Don't forget to check your intermediate answers, especially the ones in the 
second and third iteration. 

Define the number of prisoners and `kill_every` and test your function. You can try
several combinations; you may want to start with `nb_prisoners=10`, `kill_every=3`
or even smaller numbers.
'''

import numpy as np

def decimate(nb_prisoners, kill_every):
# Your code here


'''
Exercise C (Optional):
Implement one or both of the other centurions.
'''